function [ P1, P2 ] = Stiff_Prin( dt, A, B11, B12, B21, B22, C11, C12, C21, C22 )
%Build Prin Part of Stiffness matrix for quad splines, ie no boundary data
%   Archetype for surface diffusion is A(x)u_t - div[ B(x)C(x)\nabla u ] =
%   0, for A(x) is a number and B,C are 2 x 2 matrices. After int by parts
%   is \sum_j { \int_D \psi_i * A(x) * \psi_j }c'_j(t) + \sum_j {\nabla\psi_i
%   B*C*\nabla \psi_j } c_j(t) - \int_boundary {\psi_i * B * C * \nabla
%   u\cdot\ n ds}. Here \psi_i are the nodal basis functions for N_i

%   We format after separation of variables: u = \sum_i c_i(t)*\psi_i(t)

%   This code assembles and solves for the stiffness matrix coefficients in
%   terms of the boundary coefficients!  For Dirichlet problems this is
%   perfect, because all that remains to do is plug in interpolant
%   coefficients for those boundary coefficients. Since we are charting a
%   manifold, solving for the probelm in terms of the boundary coefficients
%   is ideal for glueing charts together.

%   A,B11,B12,B21,B22,C11,C12,C21,C22 are quadratic splines as formatted 
%   by my sample routines.  

%   SHORTCOMINGS OF CODE: I've only programmed two matrices.  But probably
%   if want a matrix fourier's law k(x), that matrix prob of type D\sigma;n
%   ^-1 * k(x) *(D\sigma;n)^{-1}^{tr}. If k(x) just a number, ie k = k(x)
%   Id then this isn't a problem because scalar multiplication commutes
%   with matrices. For that three-fold matrix product, we should use a
%   higher order quadrature 1+2+2+2+1 = degree 8 not 6.  But for that, I
%   only need to modify the Weights program as everything else referenced
%   that. Well and I need to program in a three-fold matrix multiplication.

%format long
%Generate lists
tri = dt.Triangulation;
vert = dt.X;
[Edge, Etri, Boundary, Vmem, VNodal, ENodal, Nodal, Nodal_Bud, Nodes, NTri, Nmem] = Lists(tri, vert);

numnodal = size(Nodal,1); %Number of Nodal Basis Functions
numbd = 2*size(Boundary,1); %Number of Boundary Nodes for a closed curve
numtri = size(dt.Triangulation,1); %Number of triangles

[W,Points] = Weights(1); %Extract the weights and Points on std element

%Grab the nodal splines formatted to each triangle as their indexed by the
%nodes.
NSpline = zeros(numtri,6,3,numnodal);
for i=1:numnodal 
    c = zeros(numnodal,1);
    c(i,1) = 1;
    NSpline(:,:,:,i) = Q_FNodal(NTri, Nodes, c);
end


%%%%%%%% Matrix on c': P1 %%%%%%%%
%These are entries of type \sum_j { \int \psi_i A(x) \psi_j }c'_j in ith row
P1 = zeros(numnodal - numbd, numnodal); %Our matrix will ultimately be 
                                        %underdetermined because solving in
                                        %terms of nodes on the boundary.
          
for i=1:numnodal - numbd %Loop over all nodal functions not on the boundary.
                       %Recall in Nodal, the boundary vertices are the last
                       %numnod entries on the list by how we built it
    k=1;
    while k<= size(Nmem,2) && Nmem(i,k) ~= 0 %Nmem(i,k) is nonvacuous triangle to which belong

         Triangle = [[vert(tri(Nmem(i,k),1),1) vert(tri(Nmem(i,k),1),2)];[vert(tri(Nmem(i,k),2),1) vert(tri(Nmem(i,k),2),2)];[vert(tri(Nmem(i,k),3),1) vert(tri(Nmem(i,k),3),2)]]; %Extract the triangle, 

         [PointsElement,J] = Std_to_Tri(Triangle, Points); %Map the Points into our triangle so know where to evaluate at.
         %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
         Triangle = [Nodes(NTri(Nmem(i,k),1),:);Nodes(NTri(Nmem(i,k),2),:);Nodes(NTri(Nmem(i,k),3),:);Nodes(NTri(Nmem(i,k),4),:);Nodes(NTri(Nmem(i,k),5),:);Nodes(NTri(Nmem(i,k),6),:)];
         Ci = Q_Terp(Triangle, NSpline(Nmem(i,k),:,3,i)'); %Extract Quadratic Coefficients
         CA = Q_Terp(Triangle, A(Nmem(i,k),:,3)'); %"
         %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
         Evali = Ci(1,1)+Ci(1,2)*PointsElement(:,1) + Ci(1,3)*PointsElement(:,2) + Ci(1,4)* PointsElement(:,1).*PointsElement(:,2) + Ci(1,5)*PointsElement(:,1).^2 + Ci(1,6)*PointsElement(:,2).^2;%Find values at standard element.
         EvalA = CA(1,1)+CA(1,2)*PointsElement(:,1) + CA(1,3)*PointsElement(:,2) + CA(1,4)* PointsElement(:,1).*PointsElement(:,2) + CA(1,5)*PointsElement(:,1).^2 + CA(1,6)*PointsElement(:,2).^2;
         J = abs(J);   
         for r = 1:6 %Go to all nodes for this triangle.
              %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
              Cj = Q_Terp(Triangle, NSpline(Nmem(i,k),:,3,NTri(Nmem(i,k),r))'); %Extract Quadratic Coefficients
              %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
              Evalj = Cj(1,1)+Cj(1,2)*PointsElement(:,1) + Cj(1,3)*PointsElement(:,2) + Cj(1,4)* PointsElement(:,1).*PointsElement(:,2) + Cj(1,5)*PointsElement(:,1).^2 + Cj(1,6)*PointsElement(:,2).^2;
              %Integrate by quadrature
              Z = (Evali.*EvalA);
              Z = Z.*Evalj;
              Z = W*Z;
              P1(i,NTri(Nmem(i,k),r)) = J*Z + P1(i,NTri(Nmem(i,k),r));
          end
          k = k + 1; %Go to next possible triangle
    end
end


%%%%%%%%% Matrix on c: P2 %%%%%%%%%%%
%Entries here are of type \sum_j {\nabla\psi_i B*C*\nabla \psi_j }
P2 = zeros(numnodal - numbd, numnodal);

for i=1:numnodal - numbd
    k=1;
    while k<= size(Nmem,2) && Nmem(i,k)~= 0 %Again cycle through all triangles for which our nodal belonds
       Triangle = [[vert(tri(Nmem(i,k),1),1) vert(tri(Nmem(i,k),1),2)];[vert(tri(Nmem(i,k),2),1) vert(tri(Nmem(i,k),2),2)];[vert(tri(Nmem(i,k),3),1) vert(tri(Nmem(i,k),3),2)]]; %Extract the triangle, 

         [PointsElement,J] = Std_to_Tri(Triangle, Points); %Map the Points into our triangle so know where to evaluate at.  Unlike nonderivative, we need the points in the triangle bc we'll need to take the deriv
                                                           %in the coordinates of the domain space.
                                                           
         
         Triangle = [Nodes(NTri(Nmem(i,k),1),:);Nodes(NTri(Nmem(i,k),2),:);Nodes(NTri(Nmem(i,k),3),:);Nodes(NTri(Nmem(i,k),4),:);Nodes(NTri(Nmem(i,k),5),:);Nodes(NTri(Nmem(i,k),6),:)];                                                  
         %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
         %Mid = [1/2*Triangle(1,:)+1/2*Triangle(2,:); 1/2*Triangle(2,:)+1/2*Triangle(3,:); 1/2*Triangle(3,:)+1/2*Triangle(1,:)];
         %TriangleElement = [Triangle; Mid]; %Augment the triangle by its midpoints
         Ci = Q_Terp(Triangle, NSpline(Nmem(i,k),:,3,i)'); %Extract Quadratic Coefficients.
         %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%                                                  
        
         %Triangle = [[0 0];[1 0];[0 1];[.5 0];[.5 .5];[0 .5]]; %We only needed actual triangle for jacobian
         
         
         CB11 = Q_Terp(Triangle, B11(Nmem(i,k),:,3)'); %"
         CB12 = Q_Terp(Triangle, B12(Nmem(i,k),:,3)'); %"
         CB21 = Q_Terp(Triangle, B21(Nmem(i,k),:,3)'); %"
         CB22 = Q_Terp(Triangle, B22(Nmem(i,k),:,3)'); %"
         CC11 = Q_Terp(Triangle, C11(Nmem(i,k),:,3)'); %"
         CC12 = Q_Terp(Triangle, C12(Nmem(i,k),:,3)'); %"
         CC21 = Q_Terp(Triangle, C21(Nmem(i,k),:,3)'); %"
         CC22 = Q_Terp(Triangle, C22(Nmem(i,k),:,3)'); %"
         
         Evaldxi = Ci(1,2) + Ci(1,4)*PointsElement(:,2) + 2*Ci(1,5)*PointsElement(:,1);%Extract the derivative values because in this term there was a space integration by parts. DERIVS WRONG BC ON STD TRIANGLE NOT DOMAIN!
         Evaldyi = Ci(1,3) + Ci(1,4)*PointsElement(:,1) + 2*Ci(1,6)*PointsElement(:,2);
         
         EvalB11 = CB11(1,1)+CB11(1,2)*PointsElement(:,1) + CB11(1,3)*PointsElement(:,2) + CB11(1,4)* PointsElement(:,1).*PointsElement(:,2) + CB11(1,5)*PointsElement(:,1).^2 + CB11(1,6)*PointsElement(:,2).^2;%Find values at standard element.
         EvalB12 = CB12(1,1)+CB12(1,2)*PointsElement(:,1) + CB12(1,3)*PointsElement(:,2) + CB12(1,4)* PointsElement(:,1).*PointsElement(:,2) + CB12(1,5)*PointsElement(:,1).^2 + CB12(1,6)*PointsElement(:,2).^2;%Find values at standard element.
         EvalB21 = CB21(1,1)+CB21(1,2)*PointsElement(:,1) + CB21(1,3)*PointsElement(:,2) + CB21(1,4)* PointsElement(:,1).*PointsElement(:,2) + CB21(1,5)*PointsElement(:,1).^2 + CB21(1,6)*PointsElement(:,2).^2;%Find values at standard element.
         EvalB22 = CB22(1,1)+CB22(1,2)*PointsElement(:,1) + CB22(1,3)*PointsElement(:,2) + CB22(1,4)* PointsElement(:,1).*PointsElement(:,2) + CB22(1,5)*PointsElement(:,1).^2 + CB22(1,6)*PointsElement(:,2).^2;%Find values at standard element.
         EvalC11 = CC11(1,1)+CC11(1,2)*PointsElement(:,1) + CC11(1,3)*PointsElement(:,2) + CC11(1,4)* PointsElement(:,1).*PointsElement(:,2) + CC11(1,5)*PointsElement(:,1).^2 + CC11(1,6)*PointsElement(:,2).^2;%Find values at standard element.
         EvalC12 = CC12(1,1)+CC12(1,2)*PointsElement(:,1) + CC12(1,3)*PointsElement(:,2) + CC12(1,4)* PointsElement(:,1).*PointsElement(:,2) + CC12(1,5)*PointsElement(:,1).^2 + CC12(1,6)*PointsElement(:,2).^2;%Find values at standard element.
         EvalC21 = CC21(1,1)+CC21(1,2)*PointsElement(:,1) + CC21(1,3)*PointsElement(:,2) + CC21(1,4)* PointsElement(:,1).*PointsElement(:,2) + CC21(1,5)*PointsElement(:,1).^2 + CC21(1,6)*PointsElement(:,2).^2;%Find values at standard element.
         EvalC22 = CC22(1,1)+CC22(1,2)*PointsElement(:,1) + CC22(1,3)*PointsElement(:,2) + CC22(1,4)* PointsElement(:,1).*PointsElement(:,2) + CC22(1,5)*PointsElement(:,1).^2 + CC22(1,6)*PointsElement(:,2).^2;%Find values at standard element.
         
         
         J = abs(J);
         for r=1:6 %Go to all nodes for this triangle                                           
             Cj = Q_Terp(Triangle, NSpline(Nmem(i,k),:,3,NTri(Nmem(i,k),r))'); %Extract Quadratic Coefficients
             Evaldxj = Cj(1,2) + Cj(1,4)*PointsElement(:,2) + 2*Cj(1,5)*PointsElement(:,1);%Extract the derivative values because in this term there was a space integration by parts.
             Evaldyj = Cj(1,3) + Cj(1,4)*PointsElement(:,1) + 2*Cj(1,6)*PointsElement(:,2);
             %BC =
             %[[B11C11+B12C21][B11C12+B12C22];[B21C11+B22C21][B21C12+B22C22]]
             
             %Integrate by Quadrature
             Z = Evaldxi.*(EvalB11.*EvalC11+EvalB12.*EvalC21).*Evaldxj + Evaldyi.*(EvalB21.*EvalC11 + EvalB22.*EvalC21).*Evaldxj + Evaldxi.*(EvalB11.*EvalC12+EvalB12.*EvalC22).*Evaldyj + Evaldyi.*(EvalB21.*EvalC12+EvalB22.*EvalC22).*Evaldyj;
             Z = W*Z;
             P2(i,NTri(Nmem(i,k),r)) = J*Z +  P2(i,NTri(Nmem(i,k),r));

         end
         k = k + 1; %Next possible triangle
    end
end

       
